@extends('frontend.include.master')
@section('content')

    <div class="wrapper default">
        <div class="container">
            <div class="row">
                <div class="main-content col-12 col-md-7 col-lg-5 mx-auto">
                    <div class="account-box">
                        <a href="#" class="logo">
                            <img src="assets/img/logo.png" alt="">
                        </a>
                        <div class="account-box-title text-right">ورود به تاپ کالا</div>
                        @if(\Illuminate\Support\Facades\Session::has('success'))
                            <div class="alert alert-success">
                                {{session('success')}}
                            </div>
                        @endif
                        <div class="account-box-content">
                            <form method="POST" action="{{ route('login') }}">
                                @csrf
                                <div class="form-account-title">ایمیل یا شماره موبایل</div>
                                <div class="form-account-row">
                                    <label class="input-label"><i class="now-ui-icons users_single-02"></i></label>
                                    <input id="email" type="email" class="input-field @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus
                                           placeholder="ایمیل یا شماره موبایل خود را وارد نمایید">
                                    @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                                <div class="form-account-title">رمز عبور
                                    <a href="" class="btn-link-border form-account-link">رمز
                                        عبور خود را فراموش
                                        کرده ام</a>
                                </div>
                                <div class="form-account-row">
                                    <label class="input-label"><i
                                            class="now-ui-icons ui-1_lock-circle-open"></i></label>
                                    <input id="password" type="password" class="input-field @error('password') is-invalid @enderror" name="password" required autocomplete="current-password"
                                           placeholder="رمز عبور خود را وارد نمایید">
                                    @error('password')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror

                                </div>
                                <div class="form-account-row form-account-submit">
                                    <div class="parent-btn">
                                        <button class="dk-btn dk-btn-info">
                                            ورود به دیجی سایت
                                            <i class="fa fa-sign-in"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="form-account-agree">
                                    <label class="checkbox-form checkbox-primary">
                                        <input type="checkbox" checked="checked" id="agree">
                                        <span class="checkbox-check"></span>
                                    </label>
                                    <label for="agree">مرا به خاطر داشته باش</label>
                                </div>
                            </form>
                        </div>
                        <div class="account-box-footer">
                            <span>کاربر جدید هستید؟</span>
                            <a href="{{route('register')}}" class="btn-link-border">ثبت‌نام در
                                تاپ کالا</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
